import numpy as np
from realCh import *

config = {
    'eqs': {
        'firOn': True,
        'dfeOn': True,
        'firDfeOn': True,
        'viterbiOn': False,
        'fwdBwdOn': False,
        'fwdOn': False,
        'neqOn': False,
        'mod': 'pam4',
        'snrList': np.arange(50, 10, -2),
        #'chSBR': [1, 0.4, 0.2, 0.1],
        #'eqSBR': [1, 0.4, 0.2, 0.1],
        'chSBR': sbr21dB,
        'eqSBR': sbr21dB,
        'dataSize': 1e6,
        'noiseFlag': 1,
        # For FFE
        'firTapNumForFir': 24,
        # For DFE
        'dfeTapNumForDfe': None,
        # For FIR+DFE
        'firTapNumForFirDfe': 24,
        'dfeTapNumForFirDfe': None,
        'firMaxTapForFirDfe': 5,
        # For Viterbi
        'blockSizeList': [100],
        # For FwdBwd
        'fwdBwdLen': 10,
        # For Fwd
        'FwdLen': 5,
        # For N-EQ
        'modelFileList': ['./results/fw_isi0_in12n64/nEQ_pam4_20dB_simp1_mse.pt'],
        'inSize': 24,
        'outSize': 1,
    },

    'prune': {
        'modelFile': './results/export/isi21dB_snrsweep_3020_in24_TRAIN/nEQ_pam4_22dB_simp1_crossEntropy.pt',
        'pruneRatio': 0.1,
        'numIterPrune': 20,
        'numFineTune': 12,
        'mod': 'pam4',
        'chSBR': sbr21dB,
        'batchSize': 8192,
        'dataSizeTrain': 1e6,
        'dataSizeValid': 1e6,
        'snrValid': 22,
        'snrTrain': 22,
        'noiseFlag': 1,
        'inSize': 24,
        'outSize': 1,
        'lossFn': 'crossEntropy',
        'lr': 1e-3,

        
    },

    'train': {
        'selTrainDataList': [1],					# 0: FwdBwd data // 1: True data
        # crossEntropy // manualCrossEntropy // mse
        'lossFnList': ['crossEntropy'],
        'useFwdBwdNeuralEq': True, 				# False : using FC neural EQ
        'mod': 'pam4',
        'snrTrainList': np.arange(20, 14, -2),
        'chSBR': sbr21dB,
        'eqSBR': sbr21dB,
        'dataSizeTrain': 1e6,
        'dataSizeValid': 1e6,
        'dataSizeTest': 1e6,
        'snrValid': 20,
        'snrTest': 20,
        'onTheFly': True,
        'noiseFlag': 1,
        'plotLoss': True,
		'trainSnrVariation': False,

		'delayOffset': None,
        'usePrunedNeuralEq': False,
        'prunedModelFile': './results/isi0_1_PRUNE/nEq_pam4_prune6.pt',

        'forceTrainIn': False,
        'mismatchSNR': None,
        # Neq Params
        'inSize': 24,
        'outSize': 1,
        'N': 32,     # 32 is optimal
        'hiddenStage': 2,
        # Train Params
        'numEpoch': 2000,
        'batchSize': 8192,
        'lr': 1e-3,
        'weightDecay': 0,
        'evalFreq': 10,

    },

    'eval': {
        'modelFileList': [
		        #'./results/export/isi21dB_snrsweep_2014_in24_TRAIN/nEQ_pam4_20dB_simp1_crossEntropy.pt',
		        #'./results/export/isi21dB_snrsweep_2014_in24_TRAIN/nEQ_pam4_18dB_simp1_crossEntropy.pt',
		        #'./results/export/isi21dB_snrsweep_2014_in24_TRAIN/nEQ_pam4_16dB_simp1_crossEntropy.pt',
				'./results/export/isi21dB_in24_fixisi_PRUNE/nEq_pam4_prune6.pt',
                ],
        'mod': 'pam4',
        'chSBR': sbr21dB_vari2,
        'dataSizeTrain': 1e7,
        'dataSizeValid': 1e7,
        'dataSizeTest': 1e7,
        'snrValid': 20,
        'snrTrain': 20,
        'snrTestList': np.arange(50,10,-2),
        'noiseFlag': 1,

        # Fine tune params
        'finetune': False,
        'lossFn': 'mse',
        'numEpoch': 100,
        'batchSize': 8192,
        'lr': 1e-3,
        'weightDecay': 0,
        'evalFreq': 10,
        'inSize': 24,
        'outSize': 1,
    },

    'pruneAnalysis':{
        'modelFileList':[
                    './results/isi0_1_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_2_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_3_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_4_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_5_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_6_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_7_PRUNE/nEq_pam4_prune6.pt',
                    './results/isi0_9_PRUNE/nEq_pam4_prune6.pt',
        ],
        'threshold': 0
    }


}
